% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_update_instance}
\alias{opsworks_update_instance}
\title{Updates a specified instance}
\usage{
opsworks_update_instance(
  InstanceId,
  LayerIds = NULL,
  InstanceType = NULL,
  AutoScalingType = NULL,
  Hostname = NULL,
  Os = NULL,
  AmiId = NULL,
  SshKeyName = NULL,
  Architecture = NULL,
  InstallUpdatesOnBoot = NULL,
  EbsOptimized = NULL,
  AgentVersion = NULL
)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}

\item{LayerIds}{The instance's layer IDs.}

\item{InstanceType}{The instance type, such as \code{t2.micro}. For a list of supported instance
types, open the stack in the console, choose \strong{Instances}, and choose
\strong{+ Instance}. The \strong{Size} list contains the currently supported
types. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Families and Types}.
The parameter values that you use to specify the various types are in
the \strong{API Name} column of the \strong{Available Instance Types} table.}

\item{AutoScalingType}{For load-based or time-based instances, the type. Windows stacks can use
only time-based instances.}

\item{Hostname}{The instance host name. The following are character limits for instance
host names.
\itemize{
\item Linux-based instances: 63 characters
\item Windows-based instances: 15 characters
}}

\item{Os}{The instance's operating system, which must be set to one of the
following. You cannot update an instance that is using a custom AMI.
\itemize{
\item A supported Linux operating system: An Amazon Linux version, such as
\verb{Amazon Linux 2}, \verb{Amazon Linux 2018.03}, \verb{Amazon Linux 2017.09},
\verb{Amazon Linux 2017.03}, \verb{Amazon Linux 2016.09},
\verb{Amazon Linux 2016.03}, \verb{Amazon Linux 2015.09}, or
\verb{Amazon Linux 2015.03}.
\item A supported Ubuntu operating system, such as \verb{Ubuntu 18.04 LTS},
\verb{Ubuntu 16.04 LTS}, \verb{Ubuntu 14.04 LTS}, or \verb{Ubuntu 12.04 LTS}.
\item \verb{CentOS Linux 7}
\item \verb{Red Hat Enterprise Linux 7}
\item A supported Windows operating system, such as
\verb{Microsoft Windows Server 2012 R2 Base},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Express},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Standard}, or
\verb{Microsoft Windows Server 2012 R2 with SQL Server Web}.
}

Not all operating systems are supported with all versions of Chef. For
more information about supported operating systems, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html}{OpsWorks Stacks Operating Systems}.

The default option is the current Amazon Linux version. If you set this
parameter to \code{Custom}, you must use the AmiId parameter to specify the
custom AMI that you want to use. For more information about how to use
custom AMIs with OpsWorks, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html}{Using Custom AMIs}.

You can specify a different Linux operating system for the updated
stack, but you cannot change from Linux to Windows or Windows to Linux.}

\item{AmiId}{The ID of the AMI that was used to create the instance. The value of
this parameter must be the same AMI ID that the instance is already
using. You cannot apply a new AMI to an instance by running
UpdateInstance. UpdateInstance does not work on instances that are using
custom AMIs.}

\item{SshKeyName}{The instance's Amazon EC2 key name.}

\item{Architecture}{The instance architecture. Instance types do not necessarily support
both architectures. For a list of the architectures that are supported
by the different instance types, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Families and Types}.}

\item{InstallUpdatesOnBoot}{Whether to install operating system and package updates when the
instance boots. The default value is \code{true}. To control when updates are
installed, set this value to \code{false}. You must then update your
instances manually by using
\code{\link[=opsworks_create_deployment]{create_deployment}} to run the
\code{update_dependencies} stack command or by manually running \code{yum} (Amazon
Linux) or \code{apt-get} (Ubuntu) on the instances.

We strongly recommend using the default value of \code{true}, to ensure that
your instances have the latest security updates.}

\item{EbsOptimized}{This property cannot be updated.}

\item{AgentVersion}{The default OpsWorks Stacks agent version. You have the following
options:
\itemize{
\item \code{INHERIT} - Use the stack's default agent version setting.
\item \emph{version_number} - Use the specified agent version. This value
overrides the stack's default setting. To update the agent version,
you must edit the instance configuration and specify a new version.
OpsWorks Stacks installs that version on the instance.
}

The default setting is \code{INHERIT}. To specify an agent version, you must
use the complete version number, not the abbreviated number shown on the
console. For a list of available agent version numbers, call
\code{\link[=opsworks_describe_agent_versions]{describe_agent_versions}}.

AgentVersion cannot be set to Chef 12.2.}
}
\description{
Updates a specified instance.

See \url{https://www.paws-r-sdk.com/docs/opsworks_update_instance/} for full documentation.
}
\keyword{internal}
