% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmsap_service.R
\name{ssmsap}
\alias{ssmsap}
\title{AWS Systems Manager for SAP}
\usage{
ssmsap(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This API reference provides descriptions, syntax, and other details
about each of the actions and data types for AWS Systems Manager for
SAP. The topic for each action shows the API request parameters and
responses.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssmsap(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=ssmsap_delete_resource_permission]{delete_resource_permission} \tab Removes permissions associated with the target database\cr
\link[=ssmsap_deregister_application]{deregister_application} \tab Deregister an SAP application with AWS Systems Manager for SAP\cr
\link[=ssmsap_get_application]{get_application} \tab Gets an application registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_get_component]{get_component} \tab Gets the component of an application registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_get_database]{get_database} \tab Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_get_operation]{get_operation} \tab Gets the details of an operation by specifying the operation ID\cr
\link[=ssmsap_get_resource_permission]{get_resource_permission} \tab Gets permissions associated with the target database\cr
\link[=ssmsap_list_applications]{list_applications} \tab Lists all the applications registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_list_components]{list_components} \tab Lists all the components registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_list_databases]{list_databases} \tab Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_list_operation_events]{list_operation_events} \tab Returns a list of operations events\cr
\link[=ssmsap_list_operations]{list_operations} \tab Lists the operations performed by AWS Systems Manager for SAP\cr
\link[=ssmsap_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP\cr
\link[=ssmsap_put_resource_permission]{put_resource_permission} \tab Adds permissions to the target database\cr
\link[=ssmsap_register_application]{register_application} \tab Register an SAP application with AWS Systems Manager for SAP\cr
\link[=ssmsap_start_application]{start_application} \tab Request is an operation which starts an application\cr
\link[=ssmsap_start_application_refresh]{start_application_refresh} \tab Refreshes a registered application\cr
\link[=ssmsap_stop_application]{stop_application} \tab Request is an operation to stop an application\cr
\link[=ssmsap_tag_resource]{tag_resource} \tab Creates tag for a resource by specifying the ARN\cr
\link[=ssmsap_untag_resource]{untag_resource} \tab Delete the tags for a resource\cr
\link[=ssmsap_update_application_settings]{update_application_settings} \tab Updates the settings of an application registered with AWS Systems Manager for SAP
}
}

\examples{
\dontrun{
svc <- ssmsap()
svc$delete_resource_permission(
  Foo = 123
)
}

}
