% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simNormalize.r
\name{simNormalize}
\alias{simNormalize}
\title{Normalization Simulator}
\usage{
simNormalize(data = NULL, volume = NULL, accuracy = 1,
  target = 0.5/17.5, tolerance = 0.1, multiple = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data.frame with simulated data. Preferably output from
\code{\link{simExtraction}}. Required columns are 'Marker', 'Allele',
'Sim', 'Volume', 'Ex.Conc', and 'DNA'.}

\item{volume}{numeric for the final volume after dilution.If NULL it will
be taken from column 'Volume'.}

\item{accuracy}{numeric for the pipetting accuracy e.g. minimum pipetting
volume.}

\item{target}{numeric for the target concentration.}

\item{tolerance}{numeric for the tolerance around the target concentration
e.g. 0.1 is +-10\%.}

\item{multiple}{logic if TRUE the function will call itself until
\code{target} is reached. Only the last round of results will be stored in
the simulated dataset.}

\item{debug}{logical flagging for debug mode.}
}
\value{
data.frame with simulation results in columns 'Norm.Avg.Conc', 'Norm.Vol',
'Norm.Aliq', 'Norm.Aliq.Prob', 'Norm.DNA', 'Norm.Conc', and 'DNA'.
}
\description{
Simulates the normalization process of a DNA extract.
}
\details{
Simulates the normalization process by binomial selection of
molecules. The average concentration per sample is used to calculate
the dilution factor.
}
\examples{
# Create a data frame with a DNA profile.
markers = rep(c("D3S1358","TH01","FGA"), each=2)
alleles = c(15,18,6,10,25,25)
df <- data.frame(Marker=markers, Allele=alleles)

# Simulate profile.
res <- simProfile(data=df, sim=3, name="Test")

# Simulate diploid sample.
res <- simSample(data=res, cells=10000, sd.cells=200)

# [OPTIONAL] Simulate degradation.
res <- simDegradation(data=res, kit="ESX17", deg=0.003, quant.target=80)

# Simulate extraction.
res <- simExtraction(data=res, vol.ex=200, sd.vol=10, prob.ex=0.3, sd.prob=0.1)

# Simulate normalization.
res <- simNormalize(data=res, volume=100)
}
\seealso{
\code{\link{simExtraction}}
}

