% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_subgroup.R, R/summarize_subgroups.R
\name{print.subgroup_fitted}
\alias{print.subgroup_fitted}
\alias{print.subgroup_validated}
\alias{print.subgroup_summary}
\title{Printing results for fitted subgroup identification models}
\usage{
\method{print}{subgroup_fitted}(x, digits = max(getOption("digits") - 3,
  3), ...)

\method{print}{subgroup_validated}(x, digits = max(getOption("digits") -
  3, 3), sample.pct = FALSE, which.quant = NULL, ...)

\method{print}{subgroup_summary}(x, p.value = 1,
  digits = max(getOption("digits") - 3, 3), ...)
}
\arguments{
\item{x}{a fitted object from either \code{fit.subgroup}, \code{validate.subgroup}, or \code{summarize.subgroups()}}

\item{digits}{minimal number of significant digits to print.}

\item{...}{further arguments passed to or from \code{\link[base]{print.default}}.}

\item{sample.pct}{boolean variable of whether to print the percent of the test sample within each subgroup. If false
the sample size itself, not the percent is printed. This may not be informative if the test sample size is much different
from the total sample size}

\item{which.quant}{when \code{validate.subgroup()} is called with a vector of quantile values specified for \code{benefit.score.quantiles},
i.e. \code{benefit.score.quantiles = c(0.25, 0.5, 0.75)}, the argument \code{which.quant} can be a vector of indexes specifying which
quantile cutoff value validation results to display, i.e. \code{which.quant = c(1,3)} in the above example results in the display of
validation results for subgroups defined by cutoff values of the benefit score defined by the 25th abnd 75th quantiles of the benefit score}

\item{p.value}{a p-value threshold for mean differences below which covariates will be displayed. For example,
setting \code{p.value = 0.05} will display all covariates that have a significant difference between subgroups
 with p-value less than 0.05. Defaults to 1, which displays all covariates}
}
\description{
Prints results for estimated subgroup treatment effects

Prints summary results for estimated subgroup treatment effects
}
\seealso{
\code{\link[personalized]{validate.subgroup}} for function which creates validation results
and \code{\link[personalized]{fit.subgroup}} for function which fits subgroup identification models.

\code{\link[personalized]{summarize.subgroups}} for function which summarizes subgroup covariate values
}
