% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_onco_recist.R
\docType{data}
\name{tr_onco_recist}
\alias{tr_onco_recist}
\title{Tumor Results (RECIST 1.1) for Oncology}
\format{
A data frame with 19 columns:
\describe{
\item{DOMAIN}{Domain Abbreviation}
\item{STUDYID}{Study Identifier}
\item{USUBJID}{Unique Subject Identifier}
\item{TRGRPID}{Group ID}
\item{TRLNKID}{Link ID}
\item{TRTESTCD}{Tumor/Lesion Assessment Short Name}
\item{TRTEST}{Tumor/Lesion Assessment Test Name}
\item{TRORRES}{Result or Finding in Original Units}
\item{TRORRESU}{Original Units}
\item{TRSTRESC}{Character Result/Finding in Std Format}
\item{TRSTRESN}{Numeric Result/Finding in Standard Units}
\item{TRSTRESU}{Standard Units}
\item{VISITNUM}{Visit Number}
\item{VISIT}{Visit Name}
\item{TREVAL}{Evaluator}
\item{TREVALID}{Evaluator Identifier}
\item{TRACPTFL}{Accepted Record Flag}
\item{TRDTC}{Date/Time of Tumor/Lesion Measurement}
\item{TRSEQ}{Sequence Number}
}
}
\source{
Generated dataset.
}
\usage{
tr_onco_recist
}
\description{
A SDTM TR dataset using RECIST 1.1 intended for examples of ADaM dataset creation
}
\details{
Tumor Results (RECIST 1.1) for Oncology

A SDTM TR dataset using RECIST 1.1 intended for examples of ADaM dataset creation

Contains a set of 3 unique Test Short Names and Test Names: \tabular{ll}{
\strong{TRTESTCD} \tab \strong{TRTEST} \cr
LDIAM    \tab Longest Diameter     \cr
LPERP    \tab Longest Perpendicular\cr
TUMSTATE \tab Tumor State
}
}
\author{
Stefan Bundfuss
}
\keyword{dataset}
