% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_connections}
\alias{ps_connections}
\title{List network connections of a process}
\usage{
ps_connections(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\value{
Data frame, or tibble if the \emph{tibble} package is available,
with columns:
\itemize{
\item \code{fd}: integer file descriptor on POSIX systems, \code{NA} on Windows.
\item \code{family}: Address family, string, typically \code{AF_UNIX}, \code{AF_INET} or
\code{AF_INET6}.
\item \code{type}: Socket type, string, typically \code{SOCK_STREAM} (TCP) or
\code{SOCK_DGRAM} (UDP).
\item \code{laddr}: Local address, string, \code{NA} for UNIX sockets.
\item \code{lport}: Local port, integer, \code{NA} for UNIX sockets.
\item \code{raddr}: Remote address, string, \code{NA} for UNIX sockets. This is
always \code{NA} for \code{AF_INET} sockets on Linux.
\item \code{rport}: Remote port, integer, \code{NA} for UNIX sockets.
\item \code{state}: Socket state, e.g. \code{CONN_ESTABLISHED}, etc. It is \code{NA}
for UNIX sockets.
}
}
\description{
For a zombie process it throws a \code{zombie_process} error.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
p <- ps_handle()
ps_connections(p)
sc <- socketConnection("httpbin.org", port = 80)
ps_connections(p)
close(sc)
ps_connections(p)
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
