/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List children;

    public BaseTree() {
    }

    public BaseTree(Tree tree) {
    }

    public Tree getChild(int n) {
        if (this.children == null || n >= this.children.size()) {
            return null;
        }
        return (BaseTree)this.children.get(n);
    }

    public List getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int n) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Tree tree = (Tree)this.children.get(i);
            if (tree.getType() != n) continue;
            return tree;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree tree) {
        if (tree == null) {
            return;
        }
        BaseTree baseTree = (BaseTree)tree;
        if (baseTree.isNil()) {
            if (this.children != null && this.children == baseTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (baseTree.children != null) {
                if (this.children != null) {
                    int n = baseTree.children.size();
                    for (int i = 0; i < n; ++i) {
                        Tree tree2 = (Tree)baseTree.children.get(i);
                        this.children.add(tree2);
                        tree2.setParent(this);
                        tree2.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = baseTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(tree);
            baseTree.setParent(this);
            baseTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Tree tree = (Tree)list.get(i);
            this.addChild(tree);
        }
    }

    public void setChild(int n, Tree tree) {
        if (tree == null) {
            return;
        }
        if (tree.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(n, tree);
        tree.setParent(this);
        tree.setChildIndex(n);
    }

    public Object deleteChild(int n) {
        if (this.children == null) {
            return null;
        }
        BaseTree baseTree = (BaseTree)this.children.remove(n);
        this.freshenParentAndChildIndexes(n);
        return baseTree;
    }

    public void replaceChildren(int n, int n2, Object object) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int n3 = n2 - n + 1;
        BaseTree baseTree = (BaseTree)object;
        ArrayList<BaseTree> arrayList = null;
        if (baseTree.isNil()) {
            arrayList = baseTree.children;
        } else {
            arrayList = new ArrayList<BaseTree>(1);
            arrayList.add(baseTree);
        }
        int n4 = arrayList.size();
        int n5 = arrayList.size();
        int n6 = n3 - n4;
        if (n6 == 0) {
            int n7 = 0;
            for (int i = n; i <= n2; ++i) {
                BaseTree baseTree2 = (BaseTree)arrayList.get(n7);
                this.children.set(i, baseTree2);
                baseTree2.setParent(this);
                baseTree2.setChildIndex(i);
                ++n7;
            }
        } else if (n6 > 0) {
            int n8;
            for (n8 = 0; n8 < n5; ++n8) {
                this.children.set(n + n8, arrayList.get(n8));
            }
            for (int i = n8 = n + n5; i <= n2; ++i) {
                BaseTree baseTree3 = (BaseTree)this.children.remove(n8);
            }
            this.freshenParentAndChildIndexes(n);
        } else {
            int n9;
            for (n9 = 0; n9 < n3; ++n9) {
                this.children.set(n + n9, arrayList.get(n9));
            }
            n9 = n4 - n3;
            for (int i = n3; i < n4; ++i) {
                this.children.add(n + i, arrayList.get(i));
            }
            this.freshenParentAndChildIndexes(n);
        }
    }

    protected List createChildrenList() {
        return new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int n) {
        int n2 = this.getChildCount();
        for (int i = n; i < n2; ++i) {
            Tree tree = this.getChild(i);
            tree.setChildIndex(i);
            tree.setParent(this);
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree tree, int n) {
        if (tree != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + tree + " found " + this.getParent());
        }
        if (n != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + n + " found " + this.getChildIndex());
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            CommonTree commonTree = (CommonTree)this.getChild(i);
            commonTree.sanityCheckParentAndChildIndexes(this, i);
        }
    }

    public int getChildIndex() {
        return 0;
    }

    public void setChildIndex(int n) {
    }

    public Tree getParent() {
        return null;
    }

    public void setParent(Tree tree) {
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isNil()) {
            stringBuffer.append("(");
            stringBuffer.append(this.toString());
            stringBuffer.append(' ');
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            BaseTree baseTree = (BaseTree)this.children.get(i);
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(baseTree.toStringTree());
        }
        if (!this.isNil()) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();
}

