/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.layout.TemplateHandler;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class InsertTextPanel
extends JPanel
implements ActionListener {
    private JChemPaintPanel jChemPaintPanel;
    private JComboBox textCombo;
    private JTextComponent editor;
    private JFrame closeafter = null;

    public InsertTextPanel(JChemPaintPanel jChemPaintPanel, JFrame closeafter) {
        this.closeafter = closeafter;
        this.setLayout(new GridBagLayout());
        Vector<String> oldText = new Vector<String>();
        oldText.add("");
        this.textCombo = new JComboBox(oldText);
        this.textCombo.setEditable(true);
        this.textCombo.setToolTipText("Enter a CAS, SMILES or InChI string");
        this.textCombo.addActionListener(this);
        this.editor = (JTextComponent)this.textCombo.getEditor().getEditorComponent();
        JButton button = new JButton("Insert");
        button.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.textCombo, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)button, gridBagConstraints);
        this.jChemPaintPanel = jChemPaintPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.equals("comboBoxEdited") || actionCommand.equals("Insert")) {
            IMolecule molecule = this.getMolecule();
            if (molecule == null) {
                return;
            }
            this.generateModel(molecule);
            if (this.closeafter != null) {
                this.closeafter.setVisible(false);
            }
        }
    }

    private IMolecule getMolecule() {
        IMolecule molecule;
        String text = (String)this.textCombo.getSelectedItem();
        if ((text = text.trim()).equals("")) {
            return null;
        }
        if (text.startsWith("InChI")) {
            try {
                InChIGeneratorFactory inchiFactory = new InChIGeneratorFactory();
                InChIToStructure inchiToStructure = inchiFactory.getInChIToStructure(text);
                INCHI_RET status = inchiToStructure.getReturnStatus();
                if (status != INCHI_RET.OKAY) {
                    JOptionPane.showMessageDialog(this.jChemPaintPanel, "Could not process InChI");
                    return null;
                }
                IAtomContainer atomContainer = inchiToStructure.getAtomContainer();
                molecule = atomContainer.getBuilder().newMolecule(atomContainer);
            }
            catch (CDKException e2) {
                JOptionPane.showMessageDialog(this.jChemPaintPanel, "Could not load InChI subsystem");
                return null;
            }
        }
        if (this.isCASNumber(text)) {
            try {
                molecule = this.getMoleculeFromCAS(text);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.jChemPaintPanel, "Error in reading data from PubChem");
                return null;
            }
        }
        SmilesParser smilesParser = new SmilesParser();
        try {
            molecule = smilesParser.parseSmiles(text);
        }
        catch (InvalidSmilesException e1) {
            JOptionPane.showMessageDialog(this.jChemPaintPanel, "Invalid SMILES specified");
            return null;
        }
        String tmp = (String)this.textCombo.getItemAt(0);
        if (tmp.equals("")) {
            this.textCombo.removeItemAt(0);
        }
        this.textCombo.addItem(text);
        this.editor.setText("");
        return molecule;
    }

    private boolean isCASNumber(String text) {
        String[] chars = text.split("-");
        if (chars.length != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (i == 2 && chars[i].length() != 1) {
                return false;
            }
            if (i == 1 && chars[i].length() != 2) {
                return false;
            }
            if (i == 0 && chars[i].length() > 6) {
                return false;
            }
            try {
                Integer.parseInt(chars[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private IMolecule getMoleculeFromCAS(String cas) throws IOException {
        Molecule molecule;
        String firstURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=pccompound&term=" + cas;
        String data = this.getDataFromURL(firstURL);
        Pattern pattern = Pattern.compile("http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi\\?cid=(\\d*)");
        Matcher matcher = pattern.matcher(data);
        String cid = null;
        boolean found = false;
        while (matcher.find()) {
            cid = matcher.group(1);
            try {
                Integer.parseInt(cid);
                found = true;
                break;
            }
            catch (NumberFormatException e) {
            }
        }
        if (!found) {
            return null;
        }
        String secondURL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?tool=jcppubchem&db=pccompound&id=" + cid;
        data = this.getDataFromURL(secondURL);
        pattern = Pattern.compile("<Item Name=\"CanonicalSmile\" Type=\"String\">([^\\s]*?)</Item>");
        matcher = pattern.matcher(data);
        String smiles = null;
        found = false;
        while (matcher.find()) {
            smiles = matcher.group(1);
            if (smiles == null && smiles.equals("")) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        SmilesParser smilesParser = new SmilesParser();
        try {
            molecule = smilesParser.parseSmiles(smiles);
        }
        catch (InvalidSmilesException e1) {
            JOptionPane.showMessageDialog(this.jChemPaintPanel, "Couldn't process data from PubChem");
            return null;
        }
        return molecule;
    }

    private String getDataFromURL(String url) throws IOException {
        String line;
        URL theURL = new URL(url);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(theURL.openStream()));
        String data = "";
        while ((line = bufferedReader.readLine()) != null) {
            data = data + line;
        }
        bufferedReader.close();
        return data;
    }

    private void generateModel(IMolecule molecule) {
        if (molecule == null) {
            return;
        }
        JChemPaintModel jcpModel = this.jChemPaintPanel.getJChemPaintModel();
        Renderer2DModel renderModel = jcpModel.getRendererModel();
        IChemModel chemModel = jcpModel.getChemModel();
        IMoleculeSet moleculeSet = chemModel.getMoleculeSet();
        if (moleculeSet == null) {
            moleculeSet = new MoleculeSet();
        }
        StructureDiagramGenerator sdg = new StructureDiagramGenerator();
        sdg.setTemplateHandler(new TemplateHandler(moleculeSet.getBuilder()));
        try {
            sdg.setMolecule(molecule);
            sdg.generateCoordinates(new Vector2d(0.0, 1.0));
            molecule = sdg.getMolecule();
            double bondLength = renderModel.getBondLength();
            double scaleFactor = GeometryTools.getScaleFactor((IAtomContainer)molecule, (double)bondLength, (HashMap)this.jChemPaintPanel.getJChemPaintModel().getRendererModel().getRenderingCoordinates());
            GeometryTools.scaleMolecule((IAtomContainer)molecule, (double)scaleFactor, (HashMap)renderModel.getRenderingCoordinates());
            if (ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel).getAtomCount() != 0) {
                GeometryTools.translate2DCenterTo((IAtomContainer)molecule, (Point2d)GeometryTools.get2DCenter((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel), (HashMap)this.jChemPaintPanel.getJChemPaintModel().getRendererModel().getRenderingCoordinates()), (HashMap)this.jChemPaintPanel.getJChemPaintModel().getRendererModel().getRenderingCoordinates());
            }
            GeometryTools.translate2D((IAtomContainer)molecule, (double)(5.0 * bondLength), (double)0.0, (HashMap)renderModel.getRenderingCoordinates());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        moleculeSet.addMolecule(molecule);
        this.jChemPaintPanel.getChemModel().setMoleculeSet(moleculeSet);
        this.jChemPaintPanel.scaleAndCenterMolecule(this.jChemPaintPanel.getChemModel());
        jcpModel.fireChange(this.jChemPaintPanel.getChemModel());
    }
}

