% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_sens_bw.R
\name{rd_sens_bw}
\alias{rd_sens_bw}
\title{Bandwidth Sensitivity Simulation for Regression Discontinuity}
\usage{
rd_sens_bw(object, bws)
}
\arguments{
\item{object}{An object returned by \code{rd_est} or \code{rd_impute}.}

\item{bws}{A positive numeric vector of bandwidth for refitting an \code{rd} object.}
}
\value{
A dataframe which contains the estimate \code{est} and standard error \code{se} 
  for each supplemented bandwidth.
}
\description{
\code{rd_sens_bw} refits the supplemented model with varying bandwidth. 
Other estimation parameters are held constant.
}
\examples{
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
rd <- rd_est(y ~ x | cov)
rd_sens_bw(rd, bws = seq(.1, 1, length.out = 5))
}
