% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mfrd.R
\name{plot.mfrd}
\alias{plot.mfrd}
\title{Plot the Multivariate Frontier Regression Discontinuity}
\usage{
\method{plot}{mfrd}(x, model = c("m_s", "m_h", "m_t"), gran = 2,
  raw_data = TRUE, color_surface = FALSE, ...)
}
\arguments{
\item{x}{An \code{mfrd} object returned by \code{mfrd_est} or contained in the object 
returned by \code{mrd_est}.}

\item{model}{Option for the model specification, one of \code{c("m_s", "m_h", "m_t")}.}

\item{gran}{Granularity of the surface grid.}

\item{raw_data}{Whether the raw data points are plotted.}

\item{color_surface}{Whether the treated surface is colored.}

\item{...}{Additional graphic arguments passed to \code{persp}.}
}
\description{
\code{plot.mfrd} plots the 3D illustration of the bivariate frontier RDD.
}
\examples{
set.seed(12345)
x1 <- runif(1000, -1, 1)
x2 <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * (x1 >= 0) + 3 * cov + 10 * (x2 >= 0) + rnorm(1000)
model <- mfrd_est(y = y, x1 = x1, x2 = x2, c1 = 0, c2 = 0, t.design = c("geq", "geq"))
plot(model, "m_s")
}
