% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdregion.R
\name{ebirdregion}
\alias{ebirdregion}
\title{Recent observations at a region or hotspot}
\usage{
ebirdregion(loc, species = NULL, back = NULL, max = NULL,
  locale = NULL, provisional = FALSE, hotspot = FALSE,
  simple = TRUE, sleep = 0, key = NULL, ...)
}
\arguments{
\item{loc}{(required) Region code or locID (for hotspots). Region code can
be country code (e.g. "US"), subnational1 (states/provinces, e.g. "US-NV"), or
subnational2 code (counties, e.g. "CA-BC-GV").}

\item{species}{eBird species code. See \code{\link{ebirdtaxonomy}} for a full
list of scientific names, common names, and species codes. Alternatively, 
you can wrap the scientific name in the \code{\link{species_code}} function 
which will return the eBird species code.
Defaults to NULL, in which case sightings for all species are returned.
See eBird taxonomy for more information:
http://ebird.org/content/ebird/about/ebird-taxonomy}

\item{back}{Number of days back to look for observations (between
1 and 30, defaults to 14).}

\item{max}{Maximum number of result rows to return in this request
(between 1 and 10000, defaults to all)}

\item{locale}{Language/locale of response (when translations are available).
See \url{http://java.sun.com/javase/6/docs/api/java/util/Locale.html} and 
\url{https://help.ebird.org/customer/portal/articles/1596582-common-name-translations-in-ebird} 
(defaults to en_US).}

\item{provisional}{Should flagged records that have not been reviewed
be included? (defaults to FALSE)}

\item{hotspot}{Should results be limited to sightings at birding hotspots?
(defaults to FALSE).}

\item{simple}{Logical. Whether to return a simple (TRUE, default) or detailed
(FALSE) set of results fields. Detailed results are only available if 
\code{loc} is a locID.}

\item{sleep}{Time (in seconds) before function sends API call (defaults to
zero.  Set to higher number if you are using this function in a loop with
many API calls).}

\item{key}{ebird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY} to avoid having to constantly 
supply the key, and to avoid accidentally sharing it publicly.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame containing the collected information:

"comName": species common name

"howMany": number of individuals observed, NA if only presence was noted

"lat": latitude of the location

"lng": longitude of the location

"locID": unique identifier for the location

"locName": location name

"locationPrivate": TRUE if location is not a birding hotspot

"obsDt": observation date formatted according to ISO 8601
   (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes are excluded
   if the observer did not report an observation time.

"obsReviewed": TRUE if observation has been reviewed, FALSE otherwise

"obsValid": TRUE if observation has been deemed valid by either the
   automatic filters or a regional viewer, FALSE otherwise

"sciName" species' scientific name
}
\description{
Returns the most recent sighting information reported in a given region or hotspot.
}
\examples{
\dontrun{
ebirdregion(loc = 'US', species = 'btbwar')
ebirdregion(loc = 'US', species = species_code('Setophaga caerulescens')) # same as above
ebirdregion(loc = 'L196159', species = 'bkcchi', back = 30)
ebirdregion('US-OH', max = 10, provisional = TRUE, hotspot = TRUE)
}
}
\references{
\url{http://ebird.org/}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
