% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{set.randomseed}
\alias{set.randomseed}
\title{Set seed with a random value using Sys.time()}
\usage{
set.randomseed(set.seed = TRUE)
}
\arguments{
\item{set.seed}{Logical. If \code{TRUE}, the default, then the function will call
\code{set.seed} internally with the new random seed.}
}
\value{
This will return the new seed invisibly. However, this is also called for
its side effects, which is a new seed set using \code{set.seed}
}
\description{
This will set a random seed.
}
\details{
This function uses 6 decimal places of \code{Sys.time()}, i.e., microseconds. Due to
integer limits, it also truncates at 1000 seconds, so there is a possibility that
this will be non-unique after 1000 seconds (at the microsecond level). In
tests, this showed no duplicates after 1e7 draws in a loop, as expected.
}
\note{
This function does not appear to be as reliable on R <= 4.1.3
}
