% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang_fn}
\alias{lang_fn}
\title{Extract function from a call}
\usage{
lang_fn(lang)
}
\arguments{
\item{lang}{Can be a call (language object), a formula quoting a
call in the right-hand side, or a frame object from which to
extract the call expression.}
}
\description{
If a frame or formula, the function will be retrieved from the
associated environment. Otherwise, it is looked up in the calling
frame.
}
\examples{
# Extract from a quoted call:
lang_fn(~matrix())
lang_fn(quote(matrix()))

# Extract the calling function
test <- function() lang_fn(call_frame())
test()
}
\seealso{
\code{\link[=lang_name]{lang_name()}}
}
