% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_parent}
\alias{env_parent}
\alias{env_tail}
\alias{env_parents}
\title{Get parent environments}
\usage{
env_parent(env = caller_env(), n = 1)

env_tail(env = caller_env(), last = global_env(), sentinel = NULL)

env_parents(env = caller_env(), last = global_env())
}
\arguments{
\item{env}{An environment.}

\item{n}{The number of generations to go up.}

\item{last}{The environment at which to stop. Defaults to the
global environment. The empty environment is always a stopping
condition so it is safe to leave the default even when taking the
tail or the parents of an environment on the search path.

\code{env_tail()} returns the environment which has \code{last} as parent
and \code{env_parents()} returns the list of environments up to \code{last}.}

\item{sentinel}{This argument is soft-deprecated, please use \code{last}
instead.}
}
\value{
An environment for \code{env_parent()} and \code{env_tail()}, a list
of environments for \code{env_parents()}.
}
\description{
\itemize{
\item \code{env_parent()} returns the parent environment of \code{env} if called
with \code{n = 1}, the grandparent with \code{n = 2}, etc.
\item \code{env_tail()} searches through the parents and returns the one
which has \code{\link[=empty_env]{empty_env()}} as parent.
\item \code{env_parents()} returns the list of all parents, including the
empty environment. This list is named using \code{\link[=env_name]{env_name()}}.
}

See the section on \emph{inheritance} in \code{\link[=env]{env()}}'s documentation.
}
\section{Life cycle}{


The \code{sentinel} argument of \code{env_tail()} has been deprecated in
rlang 0.2.0 and renamed to \code{last}.
}

\examples{
# Get the parent environment with env_parent():
env_parent(global_env())

# Or the tail environment with env_tail():
env_tail(global_env())

# By default, env_parent() returns the parent environment of the
# current evaluation frame. If called at top-level (the global
# frame), the following two expressions are equivalent:
env_parent()
env_parent(base_env())

# This default is more handy when called within a function. In this
# case, the enclosure environment of the function is returned
# (since it is the parent of the evaluation frame):
enclos_env <- env()
fn <- set_env(function() env_parent(), enclos_env)
identical(enclos_env, fn())
}
