% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-abort.R
\name{args_error_context}
\alias{args_error_context}
\title{Documentation anchor for error arguments}
\arguments{
\item{arg, error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{call, error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}
}
\description{
Use \verb{@inheritParams rlang::args_error_context} in your package to
document \code{arg} and \code{call} arguments (or equivalently their prefixed
versions \code{error_arg} and \code{error_call}).
\itemize{
\item \code{arg} parameters should be formatted as argument (e.g. using
cli's \code{.arg} specifier) and included in error messages. See also
\code{\link[=caller_arg]{caller_arg()}}.
\item \code{call} parameters should be included in error conditions in a
field named \code{call}. An easy way to do this is by passing a \code{call}
argument to \code{\link[=abort]{abort()}}. See also \code{\link[=local_error_call]{local_error_call()}}.
}
}
