% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_data_download.R
\name{npn_download_site_phenometrics}
\alias{npn_download_site_phenometrics}
\title{Download Site Phenometrics}
\usage{
npn_download_site_phenometrics(
  request_source,
  years,
  num_days_quality_filter = "30",
  coords = NULL,
  species_ids = NULL,
  genus_ids = NULL,
  family_ids = NULL,
  order_ids = NULL,
  class_ids = NULL,
  pheno_class_ids = NULL,
  station_ids = NULL,
  species_types = NULL,
  network_ids = NULL,
  states = NULL,
  phenophase_ids = NULL,
  functional_types = NULL,
  additional_fields = NULL,
  climate_data = FALSE,
  ip_address = NULL,
  dataset_ids = NULL,
  email = NULL,
  download_path = NULL,
  six_leaf_layer = FALSE,
  six_bloom_layer = FALSE,
  agdd_layer = NULL,
  six_sub_model = NULL,
  additional_layers = NULL,
  taxonomy_aggregate = NULL,
  pheno_class_aggregate = NULL,
  wkt = NULL
)
}
\arguments{
\item{request_source}{Required field, character Self-identify who is making
requests to the data service.}

\item{years}{Required field, character vector. Specify the years to include
in the search, e.g. \code{c('2013','2014')}. You must specify at least one year.}

\item{num_days_quality_filter}{Required field, defaults to \code{30}. The integer
value sets the upper limit on the number of days difference between the
first Y value and the previous N value for each individual to be included
in the data aggregation.}

\item{coords}{Numeric vector, used to specify a bounding box as a search
parameter, e.g. \code{c(lower_left_lat, lower_left_long, upper_right, lat,upper_right_long)}.}

\item{species_ids}{Integer vector of unique IDs for searching based on
species, e.g. \code{c(3, 34, 35)}.}

\item{genus_ids}{Integer vector of unique IDs for searching based on
taxonomic family, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} is also set.}

\item{family_ids}{Integer vector of unique IDs for searching based on
taxonomic family, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} is also set.}

\item{order_ids}{Integer vector of unique IDs for searching based on
taxonomic order, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} or \code{family_ids} are also set.}

\item{class_ids}{Integer vector of unique IDs for searching based on
taxonomic class, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids}, \code{family_ids} or \code{order_ids} are also set.}

\item{pheno_class_ids}{Integer vector of unique IDs for searching based on
pheno class. Note that if both \code{pheno_class_id} and \code{phenophase_id} are
provided in the same request, \code{phenophase_id} will be ignored.}

\item{station_ids}{Integer vector of unique IDs for searching based on site
location, e.g. \code{c(5, 9)}.}

\item{species_types}{Character vector of unique species type names for
searching based on species types, e.g. \code{c("Deciduous", "Evergreen")}.}

\item{network_ids}{Integer vector of unique IDs for searching based on
partner group/network, e.g. \code{c(500, 300)}.}

\item{states}{Character vector of US postal states to be used as search
params, e.g. \code{c("AZ", "IL")}.}

\item{phenophase_ids}{Integer vector of unique IDs for searching based on
phenophase, e.g. \code{c(323, 324)}.}

\item{functional_types}{Character vector of unique functional type names,
e.g. `c("Birds").}

\item{additional_fields}{Character vector of additional fields to be included
in the search results, e.g. \code{c("Station_Name", "Plant_Nickname")}.}

\item{climate_data}{Boolean value indicating that all climate variables
should be included in \code{additional_fields}.}

\item{ip_address}{Optional field, string. IP Address of user requesting data.
Used for generating data reports.}

\item{dataset_ids}{Integer vector of unique IDs for searching based on
dataset, e.g. NEON or GRSM \code{c(17,15)}.}

\item{email}{Optional field, string. Email of user requesting data.}

\item{download_path}{Character, optional file path to the file for which to
output the results.}

\item{six_leaf_layer}{Boolean value when set to \code{TRUE} will attempt to
resolve the date of the observation to a spring index, leafing value for
the location at which the observations was taken.}

\item{six_bloom_layer}{Boolean value when set to \code{TRUE} will attempt to
resolve the date of the observation to a spring index, bloom value for the
location at which the observations was taken.}

\item{agdd_layer}{Numeric value, accepts \code{32} or \code{50}. When set, the results
will attempt to resolve the date of the observation to an AGDD value for
the location; the \code{32} or \code{50} represents the base value of the AGDD value
returned. All AGDD values are based on a January 1st start date of the year
in which the observation was taken.}

\item{six_sub_model}{Affects the results of the six layers returned. Can be
used to specify one of three submodels used to calculate the spring index
values. Thus setting this field will change the results of \code{six_leaf_layer}
and \code{six_bloom_layer}. Valid values include: \code{'lilac'}, \code{'zabelli'} and
\code{'arnoldred'}. For more information see the NPN's Spring Index Maps
documentation: \url{https://www.usanpn.org/data/maps/spring}.}

\item{additional_layers}{Data frame with first column named \code{name} and
containing the names of the layer for which to retrieve data and the second
column named \code{param} and containing string representations of the
time/elevation subset parameter to use. This variable can be used to append
additional geospatial layer data fields to the results, such that the date
of observation in each row will resolve to a value from the specified
layers, given the location of the observation.}

\item{taxonomy_aggregate}{Boolean value indicating whether to aggregate data
by a taxonomic order higher than species. This will be based on the values
set in \code{family_ids}, \code{order_ids}, or \code{class_ids}. If one of those three
fields are not set, then this value is ignored.}

\item{pheno_class_aggregate}{Boolean value indicating whether to aggregate
data by the pheno class ids as per the \code{pheno_class_ids} parameter. If the
\code{pheno_class_ids} value is not set, then this parameter is ignored. This
can be used in conjunction with \code{taxonomy_aggregate} and higher taxonomic
level data filtering.}

\item{wkt}{WKT geometry by which filter data. Specifying a valid WKT within
the contiguous US will filter data based on the locations which fall within
that WKT.}
}
\value{
A tibble of all status records returned as per the search
parameters. If \code{download_path} is specified, the file path is returned
instead.
}
\description{
This function allows for a parameterized search of all site phenometrics
records in the USA-NPN database, returning all records as per the search
parameters in a data table. Data fetched from NPN services is returned as raw
JSON before being channeled into a data table. Optionally results can be
directed to an output file in which case raw JSON is converted to CSV and
saved to file; in that case, data is also streamed to file which allows for
more easily handling of the data if the search otherwise returns more data
than can be handled at once in memory.
}
\details{
This data type includes estimates of the overall onset and end of phenophase
activity for plant and animal species at a site over a user-defined time
period. Each row provides the first and last occurrences of a given
phenophase on a given species, beginning with the date of the first observed
"yes" phenophase status record and ending with the date of the last observed
"yes" record of the user-defined time period. For plant species where
multiple individuals are monitored at the site, the date provided for "first
yes" is the mean of the first "yes" records for each individual plant at the
site, and the date for "last yes" is the mean of the last "yes" records. Note
that a phenophase may have ended and restarted during the overall period of
its activity at the site. These more fine-scale patterns can be explored in
the individual phenometrics data.

Most search parameters are optional, however, users are encouraged to supply
additional search parameters to get results that are easier to work with.
\code{request_source} must be provided. This is a self-identifying string, telling
the service who is asking for the data or from where the request is being
made. It is recommended you provide your name or organization name. If the
call to this function is acting as an intermediary for a client, then you may
also optionally provide a user email and/or IP address for usage data
reporting later.

Additional fields provides the ability to specify additional, non-critical
fields to include in the search results. A complete list of additional fields
can be found in the NPN service's \href{https://docs.google.com/document/d/1yNjupricKOAXn6tY1sI7-EwkcfwdGUZ7lxYv7fcPjO8/edit#heading=h.ueaexz9bczti}{companion documentation}.
Metadata on all fields can be found in the following Excel sheet:
\url{https://www.usanpn.org/files/metadata/site_phenometrics_datafield_descriptions.xlsx}
}
\examples{
\dontrun{
#Download all saguaro data for 2013 and 2014
npn_download_site_phenometrics(
  request_source = "Your Name or Org Here",
  years = c('2013','2014'),
  species_id = c(210),
  download_path = "saguaro_data_2013_2014.csv"
)
}
}
