% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{continuousfunction}
\alias{continuousfunction}
\alias{continuous_nkde_cpp_arma_sparse}
\alias{continuous_nkde_cpp_arma}
\title{The main function to calculate continuous NKDE (with ARMADILO and sparse matrix)}
\usage{
continuous_nkde_cpp_arma_sparse(
  neighbour_list,
  events,
  weights,
  samples,
  bws,
  kernel_name,
  nodes,
  line_list,
  max_depth,
  verbose,
  div = "bw"
)

continuous_nkde_cpp_arma(
  neighbour_list,
  events,
  weights,
  samples,
  bws,
  kernel_name,
  nodes,
  line_list,
  max_depth,
  verbose,
  div = "bw"
)
}
\arguments{
\item{neighbour_list}{a list of the neighbours of each node}

\item{events}{a numeric vector of the node id of each event}

\item{weights}{a numeric vector of the weight of each event}

\item{samples}{a DataFrame of the samples (with spatial coordinates and belonging edge)}

\item{bws}{the kernel bandwidths for each event}

\item{kernel_name}{the name of the kernel to use}

\item{nodes}{a DataFrame representing the nodes of the graph (with spatial coordinates)}

\item{line_list}{a DataFrame representing the lines of the graph}

\item{max_depth}{the maximum recursion depth (after which recursion is stopped)}

\item{verbose}{a boolean indicating if the function must print its progress}

\item{div}{The divisor to use for the kernel. Must be "n" (the number of events within the radius around each sampling point), "bw" (the bandwidth) "none" (the simple sum).}
}
\value{
a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)

a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
}
\description{
The main function to calculate continuous NKDE (with ARMADILO and sparse matrix)

The main function to calculate continuous NKDE (with ARMADILO and integer matrix)
}
\keyword{internal}
