% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions_sf.R
\name{lixelize_lines.mc}
\alias{lixelize_lines.mc}
\title{Cut lines into lixels (multicore)}
\usage{
lixelize_lines.mc(
  lines,
  lx_length,
  mindist = NULL,
  verbose = TRUE,
  chunk_size = 100
)
}
\arguments{
\item{lines}{A feature collection of linestrings to convert to lixels}

\item{lx_length}{The length of a lixel}

\item{mindist}{The minimum length of a lixel. After cut, if the length of the
final lixel is shorter than the minimum distance, then it is added to the
previous lixel. If NULL, then mindist = maxdist/10}

\item{verbose}{A Boolean indicating if a progress bar must be displayed}

\item{chunk_size}{The size of a chunk used for multiprocessing. Default is
100.}
}
\value{
A feature collection of linestrings
}
\description{
Cut the lines of a feature collection of linestrings into lixels with a specified minimal
 distance may fail if the line geometries are self intersecting with
 multicore support.
}
\examples{
\donttest{
data(mtl_network)
future::plan(future::multisession(workers=2))
lixels <- lixelize_lines.mc(mtl_network,150,50)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")){
future::plan(future::sequential)
}
}
}
