% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopriEndpt.R
\name{CopriEndpt.Power}
\alias{CopriEndpt.Power}
\title{Power Calculation for Two Coprimary Endpoints.}
\usage{
CopriEndpt.Power(n, tau, mu1, mu2, rho, alpha1, alpha2, alternative)
}
\arguments{
\item{n}{sample size for the design.}

\item{tau}{information time for the interim analysis.}

\item{mu1}{mean value for coprimary endpoint 1.}

\item{mu2}{mean value for coprimary endpoint 2.}

\item{rho}{correlation coefficient between two coprimary endpoints.}

\item{alpha1}{significant level for the first stage.}

\item{alpha2}{significant level for the second stage.}

\item{alternative}{indicates the alternative hypothesis and must be one of \code{"two.sided"} or \code{"two.sided"}.}
}
\value{
The evaluated power with attributes and computational error.
}
\description{
Given the group sequential design information, returns the overall power.
}
\examples{
# Example in Chang (2014) page  272
CopriEndpt.Power(n=197, tau=0.5, mu1=0.2, mu2=0.2, rho=0.5,
alpha1=0.0025, alpha2=0.024, alternative="one.sided")
 sapply(c(-0.8,-0.5,-0.2,0,0.2,0.5,0.8),CopriEndpt.Power,
n=197, tau=0.5, mu1=0.2, mu2=0.2, alpha1=0.0025, alpha2=0.024, alternative="one.sided")
}
\author{
Yalin Zhu
}
\references{
Chang, M. (2014). Adaptive design theory and implementation using SAS and R.
\emph{CRC Press}.
}

