% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov1r.R
\name{confint.aov1r}
\alias{confint.aov1r}
\alias{print.confint.aov1r}
\title{Confidence intervals}
\usage{
\method{confint}{aov1r}(object, parm, level = 0.95, SDs = TRUE, ...)

\method{print}{confint.aov1r}(x, ...)
}
\arguments{
\item{object}{an output of \code{\link{aov1r}}}

\item{parm}{ignored}

\item{level}{confidence level}

\item{SDs}{logical, whether to return confidence intervals about the
standard deviations or about the variances}

\item{...}{ignored}

\item{x}{an output of \code{confint} applied to an \code{aov1r} object}
}
\value{
A dataframe providing the bounds of the confidence
  intervals.
}
\description{
Confidence intervals for the one-way random effect ANOVA.
}
\examples{
dat <- simAOV1R(I=2, J=3, mu=10, sigmab=1, sigmaw=1)
fit <- aov1r(y ~ group, data=dat)
confint(fit)
}
\references{
Richard K. Burdick, Franklin. A. Graybill.
\emph{Confidence Intervals on Variance Components}.
CRC Press; 1st edition (1992).
ISBN-13: 978-0824786441.
}
