% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABC.R
\name{ABC}
\alias{ABC}
\title{Evaluating ABC for each fitted model\cr}
\usage{
ABC(
  X,
  y,
  heredity = "Strong",
  nmain.p,
  sigma = NULL,
  extract = "No",
  varind = NULL,
  interaction.ind = NULL,
  pi1 = 0.32,
  pi2 = 0.32,
  pi3 = 0.32,
  lambda = 10
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} by \code{nmain.p}. Note that the two-way interaction effects should not
be included in \code{X} because this function automatically generates the
corresponding two-way interaction effects if needed.}

\item{y}{Response variable. A \code{n}-dimensional vector, where \code{n} is the number
of observations in \code{X}.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{nmain.p}{A numeric value that represents the total number of main effects
in \code{X}.}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. In such case, this function automatically estimate sigma using root mean
square error (RMSE). Default is NULL. Otherwise, users need to enter a numeric value.}

\item{extract}{A either "Yes" or "No" logical vector that represents whether or not
to extract specific columns from \code{X}. Default is "No".}

\item{varind}{Only used when \code{extract = "Yes"}. A numeric vector of class
\code{c()} that specifies the indices of variables to be extracted from \code{X}.
If \code{varind} contains indices of two-way interaction effects, then this function
automatically generates corresponding two-way interaction effects from \code{X}.}

\item{interaction.ind}{Only used when \code{extract = "Yes"}. A two-column numeric
matrix containing all possible two-way interaction effects. It must be generated
outside of this function using \code{t(utils::combn())} or \code{indchunked()}. See Example section for
details.}

\item{pi1}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to the Details section.}

\item{pi2}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to the Details section.}

\item{pi3}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to the Details section.}

\item{lambda}{A numeric value defined by users. Default is 10.
For guidance on selecting an appropriate value, please refer to the Details section.}
}
\value{
A numeric value is returned. It represents the ABC score of the fitted model.
}
\description{
This function evaluates ABC score for fitted model, one model at a time. For a model I,
the ABC is defined as
\deqn{ABC(I)=\sum\limits_{i=1}^n\bigg(Y_i-\hat{Y}_i^{I}\bigg)^2+2r_I\sigma^2+\lambda\sigma^2C_I.}
When comparing ABC of fitted models to the same data set, the smaller
the ABC, the better fit.
}
\details{
\itemize{
\item For inputs \code{pi1}, \code{pi2}, and \code{pi3}, the number needs to
satisfy the condition: \eqn{\pi_1+\pi_2+\pi_3=1-\pi_0} where \eqn{\pi_0}
is a numeric value between 0 and 1, the smaller the better.
\item For input \code{lambda}, the number needs to satisfy the condition:
\eqn{\lambda\geq 5.1/log(2)}.
}
}
\examples{
# sigma is unknown
set.seed(0)
nmain.p <- 4
interaction.ind <- t(combn(4,2))
X <- matrix(rnorm(50*4,1,0.1), 50, 4)
epl <- rnorm(50,0,0.01)
y<- 1+X[,1]+X[,2]+X[,3]+X[,4]+epl
ABC(X, y, nmain.p = 4, interaction.ind = interaction.ind)
ABC(X, y, nmain.p = 4, extract = "Yes",
    varind = c(1,2,5), interaction.ind = interaction.ind)
#'
# users want to enter a suggested value for sigma

# model with only one predictor
try(ABC(X, y, nmain.p = 4, extract = "Yes",
  varind = 1, interaction.ind = interaction.ind)) # warning message
}
\references{
Ye, C. and Yang, Y., 2019. \emph{High-dimensional adaptive minimax sparse estimation with interactions.}
}
\seealso{
\code{\link{Extract}}, \code{\link{initial}}.
}
