% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individuals_ofensive_floor_stats.R
\name{individuals_ofensive_floor_stats}
\alias{individuals_ofensive_floor_stats}
\title{individual's offensive floor stats}
\usage{
individuals_ofensive_floor_stats(df1, df2, df3)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the individual statistics of the players. The parameter has to be in the format provided by the data_adjustment() function.}

\item{df2}{Should be a Data Frame that represents the team's statistics. The parameter has to be in the format provided by the team_stats() function.}

\item{df3}{Should be a Data Frame that represents the rival's statistics. The parameter has to be in the format provided by the team_stats() function.}
}
\value{
Data frame with the following individual's offensive statistics
       \itemize{
                \item Score possessions (Sc. Poss)
                \item Possessions attacked (Poss)
                \item floor percentage (Floor\%)
                \item Offensive Rating (ORtg)
                \item Point produced per game (Pts Prod/G)
        }
}
\description{
The function allows the calculation of individual's offensive statistics on court
}
\examples{

df1 <- data.frame("name" = c("LeBron James","Team"),"G" = c(67,0),
"GS" = c(62,0),"MP" = c(2316,0),"FG" = c(643,0), "FGA" = c(1303,0),
"Percentage FG" = c(0.493,0),"3P" = c(148,0),"3PA" = c(425,0),
"Percentage 3P" = c(0.348,0),"2P" = c(495,0),"2PA" = c(878,0),
"Percentage 2P" = c(0.564,0),"FT" = c(264,0),"FTA FG" = c(381,0),
"Percentage FT" = c(0.693,0), "ORB" = c(66,0),"DRB" = c(459,0),
"TRB" = c(525,0),"AST" = c(684,0),"STL" = c(78,0),"BLK" = c(36,0),
"TOV" = c(261,0),"PF" = c(118,0),"PTS" = c(1698,0),"+/-" = c(0,0))

df2 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48),"3P" = c(782),"3PA" = c(2242),
"Percentage 3P" = c(0.349),"2P" = c(2224), "2PA" = c(4027),
"Percentage 2P" = c(0.552),"FT" = c(1260),"FTA FG" = c(1728),
"Percentage FT" = c(0.729), "ORB" = c(757),  "DRB" = c(2490),
"TRB" = c(3247), "AST" = c(1803),  "STL" = c(612),"BLK" = c(468),
"TOV" = c(1077),"PF" = c(1471),  "PTS" = c(8054),  "+/-" = c(0))

df3 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(2773),
"FGA" = c(6187),"Percentage FG" = c(0.448), "3P" = c(827),
"3PA" = c(2373), "Percentage 3P" = c(0.349),  "2P" = c(1946),
"2PA" = c(3814), "Percentage 2P" = c(0.510), "FT" = c(1270),
"FTA FG" = c(1626),  "Percentage FT" = c(0.781), "ORB" = c(668),
"DRB" = c(2333),"TRB" = c(3001),  "AST" = c(1662),"STL" = c(585),
"BLK" = c(263),   "TOV" = c(1130),  "PF" = c(1544),
"PTS" = c(7643),  "+/-" = c(0))


individuals_ofensive_floor_stats(df1,df2,df3)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
