% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineups_stats_per_possesion.R
\name{lineups_stats_per_possesion}
\alias{lineups_stats_per_possesion}
\title{Lineups stats per possesion}
\usage{
lineups_stats_per_possesion(df1, df2, df3, p, m)
}
\arguments{
\item{df1}{Should be a Data Frame. This parameter has to be in the format provided by the lineups_advance_stats() function.}

\item{df2}{Should be a Data Frame that represents the team's statistics. The parameter has to be in the format provided by the team_stats() function.}

\item{df3}{Should be a Data Frame that represents the rival's statistics. The parameter has to be in the format provided by the team_stats() function.}

\item{p}{Should be a number. This parameter has to be the number of possessions to which you want to project the statistics.}

\item{m}{should be a number. This parameter has to be the duration of a single game.}
}
\value{
Data frame whit statistics per p possesion
}
\description{
The function do the calculation of statistics per p possesion for the differents lineups
}
\details{
\itemize{
                \item The function only works with the basic statistics of the lineups.
                \item The statistical projection is made from the estimation of the possessions that the team plays when the lineups is on the court.
        }
}
\examples{

df1 <- data.frame("PG" = c("James","Rondo"),"SG" = c("Green","Caruso"),
"SF" = c("Caldwell","Kuzma"), "PF" = c("Davis","Davis"),
"C" = c("Howard ","Howard"),"MP" = c(7,1), "FG " = c(4,0),
"FGA " = c(7,0),"Percentage FG" = c(0.571,0),
"X3P  " = c(0,0),"X3PA  " = c(2,0),"Percentage 3P" = c(0,0),
"X2P " = c(4,0), "X2PA " = c(5,0), "Percentage 2P" = c(0.8,0),
"FT " = c(1,0), "FTA " = c(3,0), "Percentage FT" = c(0.333,0),
"ORB " = c(2,0), "DRB " = c(5,0),"TRB " = c(7,0), "AST " = c(2,0),
"STL " = c(1,0), "BLK " = c(0,0),"TOV " = c(7,2), "PF" = c(1,0),
"PLUS" = c(9,0),"MINUS" = c(17,3),"P/M" = c(-8,-3))

df2 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48),"3P" = c(782),"3PA" = c(2242),
"Percentage 3P" = c(0.349),"2P" = c(2224), "2PA" = c(4027),
"Percentage 2P" = c(0.552),"FT" = c(1260),"FTA FG" = c(1728),
"Percentage FT" = c(0.729), "ORB" = c(757),  "DRB" = c(2490),
"TRB" = c(3247), "AST" = c(1803),  "STL" = c(612),"BLK" = c(468),
"TOV" = c(1077),"PF" = c(1471),  "PTS" = c(8054),  "+/-" = c(0))

df3 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(2773),
"FGA" = c(6187),"Percentage FG" = c(0.448), "3P" = c(827),
"3PA" = c(2373), "Percentage 3P" = c(0.349),  "2P" = c(1946),
"2PA" = c(3814), "Percentage 2P" = c(0.510), "FT" = c(1270),
"FTA FG" = c(1626),  "Percentage FT" = c(0.781), "ORB" = c(668),
"DRB" = c(2333),"TRB" = c(3001),  "AST" = c(1662),"STL" = c(585),
"BLK" = c(263),   "TOV" = c(1130),  "PF" = c(1544),
"PTS" = c(7643),  "+/-" = c(0))


p <- 100

m <- 48

lineups_stats_per_possesion(df1,df2,df3,p,m)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
