% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-pgs-to-bed.R
\name{convert.pgs.to.bed}
\alias{convert.pgs.to.bed}
\title{Convert PGS data to BED format}
\usage{
convert.pgs.to.bed(
  pgs.weight.data,
  chr.prefix = TRUE,
  numeric.sex.chr = FALSE,
  slop = 0
)
}
\arguments{
\item{pgs.weight.data}{A data.frame containing SNP coordinate data with standardized CHROM and POS columns.}

\item{chr.prefix}{A logical indicating whether the 'chr' prefix should be used when formatting chromosome name.}

\item{numeric.sex.chr}{A logical indicating whether the sex chromosomes should be formatted numerically, as opposed to alphabetically.}

\item{slop}{An integer indicating the number of base pairs to add to the BED interval on either side.}
}
\value{
A data.frame containing the PGS component SNP coordinate data in BED format and any other columns provided in pgs.weight.data.
}
\description{
Convert imported and formatted PGS compnent SNP coordinate data to BED format.
}
\examples{
pgs.weight.data <- data.frame(
    CHROM = c('chr1', 'chrX'),
    POS = c(10, 20)
    );
convert.pgs.to.bed(pgs.weight.data);

# Switch between different chromosome notations
convert.pgs.to.bed(pgs.weight.data, chr.prefix = FALSE, numeric.sex.chr = TRUE);

# Add slop to BED intervals
convert.pgs.to.bed(pgs.weight.data, slop = 10);
}
