% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadBE.R
\name{loadBE}
\alias{loadBE}
\title{Feeding BED: Load biological entities in BED}
\usage{
loadBE(
  d,
  be = "Gene",
  dbname,
  version = NA,
  deprecated = NA,
  taxId = NA,
  onlyId = FALSE
)
}
\arguments{
\item{d}{a data.frame with information about the entities to be loaded.
It should contain the following fields: "id".
If there is a boolean column named "preferred", the value is loaded.}

\item{be}{a character corresponding to the BE type (default: "Gene")}

\item{dbname}{the DB from which the BE ID are taken}

\item{version}{the version of the DB from which the BE IDs are taken}

\item{deprecated}{NA (default) or the date when the ID was deprecated}

\item{taxId}{the taxonomy ID of the BE organism}

\item{onlyId}{a logical. If TRUE, only an BEID is created and not the
corresponding BE.}
}
\description{
Not exported to avoid unintended modifications of the DB.
}
