% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{KernelParameter}
\alias{KernelParameter}
\title{R6 class for kernel's hyperparameter}
\description{
KernelParameter contains all information and behaviour related to a kernel parameters.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# A kernel parameter can be a constant value
const_param <- KernelParameter$new(7, is_fixed = TRUE)
# It can otherwise be sampled and have its value updated through sampling
samp_param <- KernelParameter$new(1, lower_bound = 0.1,
  upper_bound = 10, slice_sampling_scale = 4)

# A kernel parameter can be associated with any type of kernel
KernelPeriodic$new(period_length = const_param, lengthscale = samp_param)
\dontshow{\}) # examplesIf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{value}}{The hyperparameter mean's prior value or its constant value}

\item{\code{is_fixed}}{Says if the kernel parameter is fixed or not (if fixed, there is no sampling)}

\item{\code{lower_bound}}{The hyperparameter's minimal value during sampling}

\item{\code{upper_bound}}{The hyperparameter's maximal value during sampling}

\item{\code{slice_sampling_scale}}{The sampling range's amplitude}

\item{\code{hparam_precision}}{Precision of the hyperparameter}

\item{\code{kernel}}{The kernel associated with the parameter (it is set at kernel instanciation)}

\item{\code{name}}{The kernel parameter's name}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{full_name}}{The kernel parameter's full name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NA-new}{\code{KernelParameter$new()}}
\item \href{#method-NA-set_kernel}{\code{KernelParameter$set_kernel()}}
\item \href{#method-unknown-clone}{\code{KernelParameter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-new"></a>}}
\if{latex}{\out{\hypertarget{method-NA-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{KernelParameter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelParameter$new(
  value,
  is_fixed = FALSE,
  lower_bound = DEFAULT_LBOUND,
  upper_bound = DEFAULT_UBOUND,
  slice_sampling_scale = log(10),
  hparam_precision = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Numeric: The hyperparameter mean's prior value (Paper - \eqn{\phi}) or its constant value}

\item{\code{is_fixed}}{Boolean: Says if the kernel parameter is fixed or not (if fixed, there is no sampling)}

\item{\code{lower_bound}}{Numeric: Hyperparameter's minimal value during sampling (Paper - \eqn{\phi_{min}})}

\item{\code{upper_bound}}{Numeric: Hyperparameter's maximal value during sampling (Paper - \eqn{\phi_{max}})}

\item{\code{slice_sampling_scale}}{Numeric: The sampling range's amplitude (Paper - \eqn{\rho})}

\item{\code{hparam_precision}}{Numeric: The hyperparameter's precision}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{KernelParameter} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-set_kernel"></a>}}
\if{latex}{\out{\hypertarget{method-NA-set_kernel}{}}}
\subsection{Method \code{set_kernel()}}{
Set \code{Kernel} for a given \code{KernelParameter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelParameter$set_kernel(kernel, param_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{kernel}}{Kernel: The kernel to associate with the parameter}

\item{\code{param_name}}{String: The parameter's name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, set a new kernel for the parameter
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unknown-clone"></a>}}
\if{latex}{\out{\hypertarget{method-unknown-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelParameter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
