% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BL.sim}
\alias{BL.sim}
\title{Simulating storms and cells}
\usage{
BL.sim(lambda = 4/240, gamma = 1/10, beta = 0.3, eta = 2, mux = 4,
  t.sim = 240)
}
\arguments{
\item{lambda}{value specifying the generation rate of storms [1/h]}

\item{gamma}{value specifying the storm duration [1/h]}

\item{beta}{value specifying the generation rate of cells [1/h]}

\item{eta}{value specifying the cell duration [1/h]}

\item{mux}{value specifying the cell intensity [mm/h]}

\item{t.sim}{value specifying the simulation time [h]}
}
\value{
\code{BL.sim} returns storms; \code{data.frame} of all storms containing information about occurence time, end time and number of cells

\code{BL.sim} returns cells; \code{data.frame} of all cells containing information about occurence time, end time, intensity and storm index
}
\description{
Bartlett-Lewis Rectangular Pulse Model
}
\details{
Model description (Rodriguez-Iturbe et al., 1987):

The model is a combination of 2 poisson processes and simulates storms and cells.
During the given simulation time storms are generated in a poisson process with rate lambda.
Those storms are given a exponetially distributed duration with parameter gamma. 
During its duration the storm generates in a second poisson process cells with rate beta.
The first cell has to be instantaneous at the time of the storm arrival.
The cell duration is exponentially distributed with parameter eta. For the whole lifetime
each cell is given a constant intensity which is exponentially distributed with parameter 1/mux.

Aggregation:

The intensities of all cells alive at time t are summed up for total precipitation at time t.

Parameter estimation:

The model parameters (lambda,gamma,beta,eta,mux) can be estimated from simulated or 
observed precipitation time series using the method of moments. Certain moments, e.g. mean, variance 
can be calculated from the time series at different aggregation levels. These moments
can also be calculated theoretically from model parameters. Both sets of statistics can be 
compared in an objective function, similar to a squared error estimator. By numerical optimization
the model parameters can be tuned to match the time series characteristics. 
\code{BL.sim} generates model realisations of storms and cells by using given model
parameters \code{lambda,gamma,beta,eta,mux} for a given simulation time \code{t.sim}
}
\examples{
lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4
t.sim <- 240
simulation <- BL.sim(lambda,gamma,beta,eta,mux,t.sim)
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

