% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Bumpers}
\alias{Bumpers}
\title{Repair costs of vehicles crashed into a barrier at 5 miles per hour}
\format{
A data frame/tibble with 23 observations on two variables
\describe{ 
\item{car}{a factor with levels \code{Buick Century},
\code{Buick Skylark}, \code{Chevrolet Cavalier}, \code{Chevrolet Corsica},
\code{Chevrolet Lumina}, \code{Dodge Dynasty}, \code{Dodge Monaco}, \code{Ford
Taurus}, \code{Ford Tempo}, \code{Honda Accord}, \code{Hyundai Sonata},
\code{Mazda 626}, \code{Mitsubishi Galant}, \code{Nissan Stanza},
\code{Oldsmobile Calais}, \code{Oldsmobile Ciere}, \code{Plymouth Acclaim},
\code{Pontiac 6000}, \code{Pontiac Grand Am}, \code{Pontiac Sunbird},
\code{Saturn SL2}, \code{Subaru Legacy}, and \code{Toyota Camry}}
\item{repair}{total repair cost (in dollars) after crashing a car into a 
barrier four times while the car was traveling at 5 miles per hour} 
}
}
\source{
Insurance Institute of Highway Safety.
}
\usage{
Bumpers
}
\description{
Data for Exercise 1.73
}
\examples{

EDA(Bumpers$repair)
stripchart(Bumpers$repair, method = "stack", pch = 19, col = "blue")
library(lattice)
dotplot(car ~ repair, data = Bumpers)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
