% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Cigar}
\alias{Cigar}
\title{Milligrams of tar in 25 cigarettes selected randomly from 4 different brands}
\format{
A data frame/tibble with 100 observations on two variables
\describe{ 
\item{tar}{amount of tar (measured in milligrams)}
\item{brand}{a factor indicating cigarette brand with levels \code{brandA}, \code{brandB},
\code{brandC}, and \code{brandD}} 
}
}
\usage{
Cigar
}
\description{
Data for Example 10.4
}
\examples{

boxplot(tar ~ brand, data = Cigar, col = "cyan", ylab = "mg tar")
anova(lm(tar ~ brand, data = Cigar))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
