% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Parented}
\alias{Parented}
\title{Education backgrounds of parents of entering freshmen at a state university}
\format{
A data frame/tibble with 200 observations on two variables
\describe{ 
\item{education}{a factor with levels \code{4yr college
degree}, \code{Doctoral degree}, \code{Grad degree}, \code{H.S grad or less},
\code{Some college}, and \code{Some grad school}} 
\item{parent}{a factor with levels \code{mother} and \code{father}} 
}
}
\usage{
Parented
}
\description{
Data for Exercise 1.32
}
\examples{

T1 <- xtabs(~education + parent, data = Parented)
T1
barplot(t(T1), beside = TRUE, legend = TRUE, col = c("blue", "red"))
rm(T1)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Parented, aes(x = education, fill = parent)) + 
    geom_bar(position = "dodge") + 
    theme_bw() +
    theme(axis.text.x  = element_text(angle = 85, vjust = 0.5)) + 
    scale_fill_manual(values = c("pink", "blue")) + 
    labs(x = "", y = "") 
}
          
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
