% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf_summary.R
\name{logistf_summary}
\alias{logistf_summary}
\alias{summary.logistf}
\title{Summary method for logistf with no printable output}
\usage{
logistf_summary(object, verbose = FALSE, ...)
}
\arguments{
\item{object}{logistf class object}

\item{verbose}{logical. If TRUE, the output will be printed}

\item{...}{Additional arguments}
}
\value{
An object class 'data.frame' showing coefficients and p_values.
}
\description{
Summary method for logistf models, currently this method is only used in \link{step_bw_firth} function.
}
\examples{
# Only use if you want a non-printable version of 'summary' for a logistfnp object.
if (requireNamespace("logistf")) {
  library(logistf)
  data <- mtcars
  data$am <- as.factor(data$am)

  regression_model <- logistf::logistf(am ~ mpg + cyl + disp, data = data)
  logistf_summary(regression_model)
}

}
\references{
Heinze G, Ploner M, Jiricka L, Steiner G. logistf: Firth’s Bias-Reduced Logistic Regression. 2023. available on: \url{https://CRAN.R-project.org/package=logistf}
}
