% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uneFonction.R
\name{lmps}
\alias{lmps}
\title{Function that handles storing our estimation and variable selection matrices during the different splits.}
\usage{
lmps(
  formula,
  data,
  method,
  N,
  p_split = 0.5,
  cores = NULL,
  direction = "backward",
  forced_var = NULL
)
}
\arguments{
\item{formula}{Regression model to use, specified as a formula.}

\item{data}{Data set to be used for regression modeling.}

\item{method}{Method for variable selection. Should be one of \code{"Lasso"} or \code{"BIC"}.}

\item{N}{Number of splits.}

\item{p_split}{Probabilities associated with the splits.}

\item{cores}{Number of cores for parallel processing.}

\item{direction}{It can take two values: \code{"backward"} and \code{"forward"}. In the case of BIC, it specifies the direction in which the selection will be made.}

\item{forced_var}{A character string specifying a predictor variable to be forced into selection. By default, it is NULL, allowing for no forced selection. If provided, this variable will be consistently selected during the N splits.}
}
\value{
An object of class lmps
}
\description{
Function that handles storing our estimation and variable selection matrices during the different splits.
}
\details{
We have data that we will split several times while shuffling it each time. Then, we will divide the data into two parts based on a specific probability for splitting. In the first half, we will perform model selection, followed by calibration on the second half. At the end of these steps, we will obtain matrices of dimensions N*p that represent the selected models and the estimated coefficients associated with these models.
}
\examples{

library(mlbench)
data("BostonHousing")
# lmps object
model = lmps(medv ~ ., data = BostonHousing, method = "Lasso", N = 50)

\donttest{
# A parallelized example
# lmps object
model = lmps(medv ~ ., data = BostonHousing, method = "Lasso", N = 50, cores = 2)
}

}
