% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_serviceline.R
\name{pof_future_serviceline}
\alias{pof_future_serviceline}
\title{Future Probability of Failure for Service Line}
\usage{
pof_future_serviceline(
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  reliability_factor = "Default",
  age,
  k_value = 0.0329,
  c_value = 1.087,
  normal_expected_life = 75,
  simulation_end_year = 100
)
}
\arguments{
\item{utilisation_pct}{Numeric Utilisation Percentage}

\item{operating_voltage_pct}{Numeric Operating Voltage Percentage}

\item{sheath_test}{String Sheath Test}

\item{partial_discharge}{String Partial Discharge}

\item{fault_hist}{String Fault Histogram}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{age}{Numeric. The current age in years of the conductor.}

\item{k_value}{Numeric. \code{k_value = 0.0069} by default. This number is
given in a percentage. The default value is accordingly to the CNAIM standard
on p. 110.}

\item{c_value}{Numeric. \code{c_value = 1.087} by default.
The default value is accordingly to the CNAIM standard see page 110}

\item{normal_expected_life}{Numeric. \code{normal_expected_life = 60} by default.
The default value is accordingly to the CNAIM standard on page 107.}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
DataFrame. Future probability of failure
along with future health score
}
\description{
This function calculates the future
annual probability of failure per kilometer for a service line
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function.
}
\examples{
# future annual probability of failure for service line, 50 years old
pof_future_serviceline(
utilisation_pct = 80,
operating_voltage_pct = 60,
sheath_test = "Default",
partial_discharge = "Default",
fault_hist = "Default",
reliability_factor = "Default",
age = 50,
k_value = 0.0329,
c_value = 1.087,
normal_expected_life = 75,
simulation_end_year = 100)
}
