% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_board_04kv.R
\name{safety_cof_board_04kv}
\alias{safety_cof_board_04kv}
\title{Safety cost of Failure for 0.4kV Board}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
safety_cof_board_04kv(location_risk, type_risk)
}
\arguments{
\item{location_risk}{String Type Financial factor criteria for 0.4kV board
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{location_risk = c("Low", "Medium", "High")}.
The default setting is
\code{location_risk = "Medium"}.}

\item{type_risk}{String. Asses Financial factor criteria for 0.4kV board
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{type_risk = c("Low", "Medium", "High")}.
The default setting is
\code{type_risk = "Medium"}.}
}
\value{
Numeric. Financial consequences of failure for 0.4kV board
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Safety consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
Outputted in (DKK).
}
\examples{
safety_cof_board_04kv(
location_risk = "Default",
type_risk = "Default")
}
