% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_chq_beta.R
\name{CPP.Choquet.Beta}
\alias{CPP.Choquet.Beta}
\title{CPP by Choquet integrals, using Beta PERT distributions}
\usage{
CPP.Choquet.Beta(x, s)
}
\arguments{
\item{x}{Decision matrix of Alternatives (rows) and Criteria (columns). Benefit criteria must be positive and cost criteria must be negative.}

\item{s}{Shape of a Beta PERT distribution, as described in the package 'mc2d'. There is no default value, however the higher the shape the higher the kurtosis, which emulates the precision of data elicited from experts.}
}
\value{
PMax are the joint probabilities of each alternative being higher than the others, per criterion. Capacities are the interactions of all combined criteria, computed by the Progressive-Optimistic (PO) point of view. Choq returns the alternatives' scores by Choquet integrals and their respetive rankings for decisionmaking. Shap returns the Shapley indices, which are associated with criteria weights.
}
\description{
This function computes the CPP by Choquet integrals, using Beta PERT distributions to randomize the decision matrix. The CPP by Choquet integrals is used to rank alternatives in multicriteria decision problems.
}
\examples{
# Alternatives' original scores
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
x = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5) # Decision matrix
s = 4 # Shape
CPP.Choquet.Beta(x,s)
}
\references{
Sant'Anna, Annibal P. (2015). Probabilistic Composition of Preferences: Theory and Applications, Springer.
}
