% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_malm_beta.R
\name{CPP.Malmquist.Beta}
\alias{CPP.Malmquist.Beta}
\title{CPP by the Malmquist Index, using Beta PERT distributions}
\usage{
CPP.Malmquist.Beta(m1, m2, s)
}
\arguments{
\item{m1}{Decision matrix of Alternatives (rows) and Criteria (columns) in moment '1'. Benefit criteria must be positive and cost criteria must be negative.}

\item{m2}{Decision matrix of Alternatives (rows) and Criteria (columns) in the following moment '2'. Benefit criteria must be positive and cost criteria must be negative.}

\item{s}{Shape of a Beta PERT distribution, as described in the package 'mc2d'. There is no default value, however the higher the shape the higher the kurtosis, which emulates the precision of data.}
}
\value{
MC gives the Malmquist Conservative index. MP gives the Malmquist Progressive index. Finally, Index gives the CPP-Malmquist of all alternatives and their rankings for decisionmaking. The indices greater than one represent a relative evolution of the alternative between the two periods, while the indices lower than one reveal the alternatives that decreased performance in relation to the others.
}
\description{
The CPP-Malmquist is used to dynamic evaluation of alternatives, in multicriteria problems, considering two different moments.
}
\examples{
# Alternatives' original scores
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
m1 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5) # Decision matrix of the previous moment '1'.
Alt.1 = c(3,29,82,-3)
Alt.2 = c(6,28,70,-8)
Alt.3 = c(2,20,99,-8)
Alt.4 = c(5,31,62,-14)
Alt.5 = c(9,27,73,-5)
m2 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5) # Decision matrix of the following moment '2'.
s = 4 # Shape
CPP.Malmquist.Beta(m1,m2,s)
}
