% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.posterior.R
\name{summarize.posterior}
\alias{summarize.posterior}
\title{Summarize trends in the posterior}
\usage{
summarize.posterior(posterior, threshold = 0.01, rate_name = "lambda", 
return_data = FALSE, rm_singleton = FALSE, per_time = TRUE, 
window_size = 1, relative_deltas = FALSE)
}
\arguments{
\item{posterior}{a list of CRABS objects, each one representing a sample from the posterior}

\item{threshold}{a threshold for when \eqn{\Delta \lambda i} should be interpreted as decreasing, flat, or increasing}

\item{rate_name}{either "lambda" or "mu" or "delta"}

\item{return_data}{instead of plots, return the plotting dataframes}

\item{rm_singleton}{whether or not to remove singletons. Pass starting at present, going towards ancient}

\item{per_time}{whether to compute \eqn{\Delta\lambda i} that are in units of per time, i.e. divide by \eqn{\Delta t}}

\item{window_size}{the window size "k" in \eqn{\Delta\lambda i = \lambda i - \lambda(i-k)}}

\item{relative_deltas}{whether to divide \eqn{\Delta \lambda i} by the local lambda value}
}
\value{
a ggplot object
}
\description{
Summarize trends in the posterior
}
\examples{
data(primates_ebd_log)

posterior <- read.RevBayes(primates_ebd_log, max_t = 65, n_samples = 10)

samples <- sample.congruence.class.posterior(posterior, 
                                             num.samples = 5,
                                             rate.type = "extinction",
                                             rate0.median = 0.1,
                                             model = "MRF",
                                             max.rate = 1.0)

p <- summarize.posterior(samples, threshold = 0.05)
}
