% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_RainFARM.R
\name{RainFARM}
\alias{RainFARM}
\title{RainFARM stochastic precipitation downscaling (reduced version)}
\usage{
RainFARM(
  data,
  lon,
  lat,
  nf,
  weights = 1,
  nens = 1,
  slope = 0,
  kmin = 1,
  fglob = FALSE,
  fsmooth = TRUE,
  nprocs = 1,
  time_dim = NULL,
  lon_dim = "lon",
  lat_dim = "lat",
  drop_realization_dim = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Precipitation array to downscale. The input array is expected to 
have at least two dimensions named "lon" and "lat" by default (these default 
names can be changed with the \code{lon_dim} and \code{lat_dim} parameters)
and one or more dimensions over which to average these slopes, which can be 
specified by parameter \code{time_dim}. The number of longitudes and 
latitudes in the input data is expected to be even and the same. If not
the function will perform a subsetting to ensure this condition.}

\item{lon}{Vector or array of longitudes.}

\item{lat}{Vector or array of latitudes.}

\item{nf}{Refinement factor for downscaling (the output resolution is 
increased by this factor).}

\item{weights}{Multi-dimensional array with climatological weights which can 
be obtained using the \code{CST_RFWeights} function. If \code{weights = 1.} 
(default) no weights are used. The names of these dimensions must be at 
least the same longitudinal and latitudinal dimension names as data.}

\item{nens}{Number of ensemble members to produce (default: \code{nens = 1}).}

\item{slope}{Prescribed spectral slope. The default is \code{slope = 0.}
meaning that the slope is determined automatically over the dimensions 
specified by \code{time_dim}. A 1D array with named dimension can be 
provided (see details and examples).}

\item{kmin}{First wavenumber for spectral slope (default: \code{kmin = 1}).}

\item{fglob}{Logical to conseve global precipitation over the domain 
(default: FALSE).}

\item{fsmooth}{Logical to conserve precipitation with a smoothing kernel 
(default: TRUE).}

\item{nprocs}{The number of parallel processes to spawn for the use for 
parallel computation in multiple cores. (default: 1)}

\item{time_dim}{String or character array with name(s) of time dimension(s)
(e.g. "ftime", "sdate", "time" ...) over which to compute spectral slopes.
If a character array of dimension names is provided, the spectral slopes
will be computed over all elements belonging to those dimensions.
If omitted one of c("ftime", "sdate", "time") is searched and the first one 
with more than one element is chosen.}

\item{lon_dim}{Name of lon dimension ("lon" by default).}

\item{lat_dim}{Name of lat dimension ("lat" by default).}

\item{drop_realization_dim}{Logical to remove the "realization" stochastic 
ensemble dimension (default: FALSE) with the following behaviour if set to 
TRUE:
\enumerate{
  \item{if \code{nens == 1}: the dimension is dropped;}
  \item{if \code{nens > 1} and a "member" dimension exists: the "realization" 
  and "member" dimensions are compacted (multiplied) and the resulting 
  dimension is named "member";}
  \item{if \code{nens > 1} and a "member" dimension does not exist: the 
  "realization" dimension is renamed to "member".}
}}

\item{verbose}{logical for verbose output (default: FALSE).}
}
\value{
RainFARM() Returns a list containing the fine-scale longitudes, 
 latitudes and the sequence of \code{nens} downscaled fields. If 
 \code{nens > 1} an additional dimension named "realization" is added to the 
 output array after the "member" dimension (if it exists and unless 
 \code{drop_realization_dim = TRUE} is specified). The ordering of the 
 remaining dimensions in the \code{exp} element of the input object is 
 maintained.
}
\description{
This function implements the RainFARM stochastic precipitation downscaling method
and accepts in input an array with named dims ("lon", "lat")
and one or more dimension (such as "ftime", "sdate" or "time")
over which to average automatically determined spectral slopes.
Adapted for climate downscaling and including orographic correction.
References:
Terzago, S. et al. (2018). NHESS 18(11), 2825-2840. \doi{10.5194/nhess-18-2825-2018},
D'Onofrio et al. (2014), J of Hydrometeorology 15, 830-843; Rebora et. al. 
(2006), JHM 7, 724.
}
\details{
Wether parameter 'slope' and 'weights' presents seasonality 
dependency, a dimension name should match between these parameters and the 
input data in parameter 'data'. See example 2 below where weights and slope 
vary with 'sdate' dimension.
}
\examples{
# Example for the 'reduced' RainFARM function 
nf <- 8   # Choose a downscaling by factor 8
exp <- 1 : (2 * 3 * 4 * 8 * 8)
dim(exp) <- c(dataset = 1, member = 2, sdate = 3, ftime = 4, lat = 8, lon = 8)
lon <- seq(10, 13.5, 0.5)
lat <- seq(40, 43.5, 0.5)
# Create a test array of weights
ww <- array(1., dim = c(lon = 8 * nf, lat = 8 * nf))
res <- RainFARM(data = exp, lon = lon, lat = lat, nf = nf, 
               weights = ww, nens = 3, time_dim = 'ftime')
}
\author{
Jost von Hardenberg - ISAC-CNR, \email{j.vonhardenberg@isac.cnr.it}
}
