% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.cancergram_model}
\alias{predict.cancergram_model}
\title{Predict anticancer peptides}
\usage{
\method{predict}{cancergram_model}(object, newdata, ...)
}
\arguments{
\item{object}{\code{cancergram_model} object.}

\item{newdata}{\code{list} of sequences (for example as given by
\code{\link[biogram]{read_fasta}} or \code{\link{read_txt}}).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{list} of objects of class \code{single_cancergram_pred}. 
Each object of this class contains analyzed sequence, values of predictions 
for 5-mers and result of the prediction for the whole peptide/protein.
}
\description{
Recognizes anticancer peptides using the CancerGram algorithm.
}
\details{
CancerGram requires the external package, CancerGramModel, which 
contains models necessary to perform the prediction. The model 
can be installed using \code{\link{install_CancerGramModel}}.

Predictions for each protein are stored in objects of class 
\code{single_cancergram_pred}. It consists of three elements:
\describe{
  \item{seq}{Character vector of amino acid sequence of an analyzed peptide/protein}
  \item{all_mers_pred}{Matrix of predictions for each 5-mer (subsequence
  of 5 amino acids) of a sequence. Each row corresponds to one mer and columns
  to predicted classes (ACP, AMP or negative). Prediction value indicates probability 
  that a 5-mer possesses anticancer activity (acp), antimicrobial activity (amp) or 
  none of them (neg).}
  \item{single_prot_pred}{One row matrix of a single prediction value for
  a whole peptide/protein. Its value corresponds to the probability that a
  peptide/protein exhibits anticancer activity, antimicrobial activity or none
  of them.}
}
}
