% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_tracking.R
\name{track_params}
\alias{track_params}
\title{Track Analysis Parameters}
\usage{
track_params(params, analysis_name = NULL, description = NULL, registry_file)
}
\arguments{
\item{params}{Named list of parameters to track}

\item{analysis_name}{Character. Name/identifier for this analysis}

\item{description}{Character. Description of what these parameters control}

\item{registry_file}{Character. Path to parameter registry (required).}
}
\value{
List containing parameter information
}
\description{
Record analysis parameters and configuration settings for reproducibility
}
\examples{
\dontrun{
# Track model parameters
params <- list(
  learning_rate = 0.01,
  epochs = 100,
  batch_size = 32,
  model_type = "neural_network"
)
track_params(params, "model_training", "Deep learning model parameters",
             registry_file = tempfile(fileext = ".json"))
}
}
