% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_tracking.R
\name{track_reference_genome}
\alias{track_reference_genome}
\title{Track Reference Genome}
\usage{
track_reference_genome(
  fasta_path,
  gtf_path = NULL,
  gff_path = NULL,
  genome_build = NULL,
  species = NULL,
  source_url = NULL,
  indices = list(),
  metadata = list(),
  registry_file,
  data_registry_file
)
}
\arguments{
\item{fasta_path}{Character. Path to reference genome FASTA file}

\item{gtf_path}{Character. Path to GTF annotation file. Optional.}

\item{gff_path}{Character. Path to GFF annotation file. Optional.}

\item{genome_build}{Character. Genome build identifier (e.g., "GRCh38", "mm10")}

\item{species}{Character. Species name (e.g., "Homo sapiens", "Mus musculus")}

\item{source_url}{Character. URL where reference was downloaded from}

\item{indices}{Named list. Paths to aligner indices (STAR, BWA, etc.)}

\item{metadata}{List. Additional metadata about the reference}

\item{registry_file}{Character. Path to reference registry (required).}

\item{data_registry_file}{Character. Path to data registry for tracking files (required).}
}
\value{
List containing reference genome information
}
\description{
Track reference genome files, annotations, and indices for reproducibility.
This is critical for genomics/transcriptomics pipelines where the exact
reference version affects results.
}
\examples{
\dontrun{
track_reference_genome(
  fasta_path = "ref/GRCh38.fa",
  gtf_path = "ref/gencode.v38.annotation.gtf",
  genome_build = "GRCh38",
  species = "Homo sapiens",
  source_url = "https://www.gencodegenes.org/",
  indices = list(
    star = "ref/STAR_index/",
    bwa = "ref/bwa_index/GRCh38"
  ),
  registry_file = tempfile(fileext = ".json"),
  data_registry_file = tempfile(fileext = ".json")
)
}
}
