% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoDaImpact-package.R
\docType{data}
\name{toulouse_retail}
\alias{toulouse_retail}
\title{Simulated retail data for nine shopping malls in the city of Toulouse}
\format{
An object of class \code{sf} (inherits from \code{data.table}, \code{data.frame}) with 428 rows and 6 columns.
}
\source{
\itemize{
\item The figures for \code{POP} and \code{MEDIAN_INCOME} come from the \href{https://www.insee.fr/fr/information/4467366}{French census data prided by INSEE}.
\item The polygon \code{geometry} is \href{https://geoservices.ign.fr/contoursiris}{provided by the IGN}.
\item The locations of the nine shopping malls around the city center are derived from online mapping services (Google Maps and OpenStreetMap).
\item The distances (\code{dist_km}) are derived from location information.
\item The number of shopping trips (\code{visits}) are simulated by the authors.
}
}
\usage{
toulouse_retail
}
\description{
This data set provides an example for the use of CoDa models in geomarketing applications.
The data is simulated, but realistic in the sense that the parameters used for the simulation
were estimated on a real, but confidential data set (Dargel and Thomas-Agnan 2024).
}
\details{
\itemize{
\item \code{ID_IRIS}: Identifies the geographic region.
\item \code{POP}: Population number within the region
\item \code{MEDIAN_INCOME}: The median income in the region
\item \code{dist_km}: Distances from the region to all nine shopping malls.
\item \code{visits}: The share of visitors that coming from the region and going to each of the malls.
\item \code{geometry}: The geometry (polygon) of the region
\item The "mall_locations" and the "simulation_parameters" are given as additional attributes.
}
}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Lukas Dargel & Christine Thomas-Agnan (2024) “The link between multiplicative competitive interaction models and compositional data regression with a total”, Journal of Applied Statistics, DOI: 10.1080/02664763.2024.2329923
}\if{html}{\out{</div>}}
}
\author{
Lukas Dargel, Christine Thomas-Agnan
}
\keyword{data}
