% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortConstruction.R
\name{getLastGeneratedCohortChecksums}
\alias{getLastGeneratedCohortChecksums}
\title{Get last generated cohort checksums}
\usage{
getLastGeneratedCohortChecksums(
  connectionDetails = NULL,
  connection = NULL,
  cohortId = NULL,
  cohortDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  .checkTables = TRUE
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortId}{cohortId to check. If NULL, all cohorts will be returned.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{.checkTables}{used internally}
}
\description{
This gets a log of the last checksum for each cohort id stored in the cohort_checksum table.

This should be used to audit cohort generation as (if generated with cohort_generator) cohorts should always have an
end time in this table. The last end time will be the cohort that is in the cohort table (assuming no other manual
modifications are made to the cohort table itself).

This can be used downstream of CohortGenerator to evaluate if cohorts are consistent with passed definitions.
}
