% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidCoreCoverConcept.R
\name{centroidCoreCover}
\alias{centroidCoreCover}
\title{Compute centroid of the core cover}
\usage{
centroidCoreCover(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Centroid of the core cover for a quasi-balanced game specified by a game vector
}
\description{
Calculates the centroid of the core cover for specified game.
}
\examples{
library(CoopGame)
v=c(0,0,0,2,2,3,5)
centroidCoreCover(v) 

}
\references{
Tijs S.H. and Lipperts F.A.S. (1982) "The hypercube and the core cover of n-person cooperative games", Cahiers du Centre d' Etudes de Researche Operationelle 24, pp. 27--37

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 45--46
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
