% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DictatorGame.R
\name{dictatorGameValue}
\alias{dictatorGameValue}
\title{Compute value of a coalition for a dictator game}
\usage{
dictatorGameValue(S, dictator)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{dictator}{Number of the dictator}
}
\value{
\code{1} if dictator is involved in coalition, \code{0} otherwise.
}
\description{
\strong{Coalition value for a dictator game:} \cr
For further information see \link{dictatorGame}
}
\examples{
library(CoopGame)
dictatorGameValue(S=c(1,2,3),dictator=2)

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 295

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 764
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
