predict_DDPstar.quantfun <-
function(object, newdata, p, parallel = c("no", "multicore", "snow"), ncpus = 1, cl = NULL) {
	doMCMC <- function(k, object, Xp, p) {		
		quantfun <- matrix(0, nrow = nrow(Xp), ncol = length(p))
		ncomp <- ncol(object$fit$probs)
		 if(ncomp == 1) {
	      Beta <- matrix(object$fit$beta[k,,], nrow = 1)
	    } else {
	      Beta <- object$fit$beta[k,,]
	    }
		mu <- Xp%*%t(Beta)
		w <- object$fit$probs[k,]
		sd <- object$fit$sd[k,]
		for(i in 1:nrow(Xp)) {
			#aux <- norMix(mu = c(mu[i,]), sigma = sd, w = w)
			#quantfun[i,] <- qnorMix(p, aux)
			for(j in 1:length(p)) {
				quantfun[i,j] <- F_inv_code(p = p[j], w = w, mean = c(mu[i,]), sd = sd)
			}
		}
		res <- list()
		res$quantfun <- quantfun
		res$foo <- 1
		res

	}

	Xp <- predict.design.matrix.DDPstar(object = object, newdata = newdata)$X
	
	parallel <- match.arg(parallel)
	nsim <- nrow(object$fit$sd)

	if(nsim > 0) {
		do_mc <- do_snow <- FALSE
	    if (parallel != "no" && ncpus > 1L) {
	        if (parallel == "multicore") {
	            do_mc <- .Platform$OS.type != "windows"
	        } else if (parallel == "snow") {
	            do_snow <- TRUE
	        }
	        if (!do_mc && !do_snow) {
	            ncpus <- 1L
	        }       
	        loadNamespace("parallel") # get this out of the way before recording seed
	    }

	    resMCMC <- if (ncpus > 1L && (do_mc || do_snow)) {
                if (do_mc) {
                    parallel::mclapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, p = p, mc.cores = ncpus)
                } else if (do_snow) {                
                    if (is.null(cl)) {
                        cl <- parallel::makePSOCKcluster(rep("localhost", ncpus))
                        if(RNGkind()[1L] == "L'Ecuyer-CMRG") {
                            parallel::clusterSetRNGStream(cl)
                        }
                        res <- parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, p = p)
                        parallel::stopCluster(cl)
                        res
                    } else {
                        if(!inherits(cl, "cluster")) {
                            stop("Class of object 'cl' is not correct")
                        } else {
                            parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, p = p)
                        }                        
                    }
                }
            } else {
                lapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, p = p)
            }

        resMCMC <- simplify2array(resMCMC)
        quantfun <- aperm(simplify2array(resMCMC["quantfun",]), c(1,3,2))

	} else {
		stop("nsave should be larger than zero.")
	}
	res <- list()
	res$Xp <- Xp
	res$p <- p
	res$quantfun <- quantfun
	class(res) <- "DDPstar.quantfun"
	res
}
