% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findDampeningConstant.R
\name{findDampeningConstant}
\alias{findDampeningConstant}
\title{findDampeningConstant}
\usage{
findDampeningConstant(S, B, goldStandard)
}
\arguments{
\item{S}{List output from trimData$Sig (S)}

\item{B}{List output from trimData$dataBulk (B)}

\item{goldStandard}{Starting point for the weights, determined by solving OLS}
}
\value{
value (dampening constant value)
}
\description{
Finds a dampening constant for the weights using cross-validation.
The goldStandard is used to define the weights. Multiple values of the
dampening constant (multiplier) are tried. For each attempt,
the variance of the dampened weighted solution for a subset of genes is
calculated (on a randomly selected half of the genes).
Note that infinite weights are ignored.The dampening constant that
results in least cross-validation variance is chosen. It functions
in a nondeterministic manner. The dampening constant defines the maximum
value that any weight can take on.
}
\examples{
\donttest{
#Sig
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/Sig.RData"
#dest <- "data/Sig.RData"
#download.file(url, dest)
#load("data/Sig.RData")
load(system.file("extdata", "Sig.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

trimmed <- trimData(Sig, dataBulk)
S <- trimmed$sig
B <- trimmed$bulk
solution <- solveOLSInternal(S,B)
findDampeningConstant(S, B, solution)
}

}
