% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m.auc.R
\name{m.auc}
\alias{m.auc}
\title{m.auc}
\usage{
m.auc(dataset, grouping)
}
\arguments{
\item{dataset}{Data}

\item{grouping}{Data subdivision}
}
\value{
Matrix of standardized output of AUC calculation
}
\description{
Calculates the AUC of a dataset. The function mainly serves
to support the DWLS function.
}
\examples{

\donttest{

#dataSC
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataSC.RData"
#dest <- "data/dataSC.RData"
#load(download.file(url, tempfile(data/dataSC.RData))
#load("dataSC.RData")
#SOLUTION
load(system.file("extdata", "dataSC.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#load(download.file(url, tempfile(dest)))
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

#labels
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/labels.RData"
#dest <- "data/labels.RData"
#download.file(url, dest)
#load("data/labels.RData")
load(system.file("extdata", "labels.RData", package = "DWLS"))

#data('trueLabels', package = "DWLS")
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/trueLabels.RData"
#dest <- "data/trueLabels.RData"
#download.file(url, dest)
#load("data/trueLabels.RData")
load(system.file("extdata", "trueLabels.RData", package = "DWLS"))

pseudo.count = 0.1
data.used.log2 <- log2(dataSC+pseudo.count)
colnames(data.used.log2)<-make.unique(colnames(data.used.log2))
diff.cutoff=0.5
id = labels
for (i in unique(id)){
  cells.symbol.list2 = colnames(data.used.log2)[which(id==i)]
  cells.coord.list2 = match(cells.symbol.list2, colnames(data.used.log2))
  cells.symbol.list1 = colnames(data.used.log2)[which(id != i)]
  cells.coord.list1= match(cells.symbol.list1, colnames(data.used.log2))
  data.used.log2.ordered = cbind(data.used.log2[,cells.coord.list1],
                                         data.used.log2[,cells.coord.list2])
  group.v <- c(rep(0,length(cells.coord.list1)),
                               rep(1, length(cells.coord.list2)))
  #ouput
  log2.stat.result <- stat.log2(data.used.log2.ordered,
                                    group.v, pseudo.count)
  Auc <- m.auc(data.used.log2.ordered, group.v)}
}

}
