% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveOLSInternal.R
\name{solveOLSInternal}
\alias{solveOLSInternal}
\title{solveOLSInternal}
\usage{
solveOLSInternal(S, B)
}
\arguments{
\item{S}{List output from trimData$sig (S)}

\item{B}{List output from trimData$bulk (B)}
}
\value{
Cell numbers
}
\description{
This function solves or the unknown parameters
using ordinary least squares (OLS) without printing the output.
It returns the cell numbers, not the proportions (see solveOLS).
}
\examples{
\donttest{
#Sig
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/Sig.RData"
#dest <- "data/Sig.RData"
#download.file(url, dest)
#load("data/Sig.RData")
load(system.file("extdata", "Sig.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

trimmed <- trimData(Sig, dataBulk)
S <- trimmed$sig
B <- trimmed$bulk
solveOLSInternal(S, B)
}
}
