% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRed.R
\name{coinertia.drbats}
\alias{coinertia.drbats}
\title{Perform Coinertia Analysis on the PCA
of the Weighted PCA and Deville's PCA}
\usage{
coinertia.drbats(
  X.histo = NULL,
  Qp = NULL,
  X = NULL,
  t = NULL,
  t.range = c(0, 1000),
  breaks
)
}
\arguments{
\item{X.histo}{the data matrix projected onto the histogram basis}

\item{Qp}{a matrix of weights, if Qp = NULL the function specifies a diagonal weight matrix}

\item{X}{a data matrix, if X.histo is NULL and needs to be built}

\item{t}{a matrix of observation times, if X.histo is NULL and needs to be built}

\item{t.range}{the range of observation times in vector form,
if X.histo is NULL and needs to be built (default: t.range = c(0, 1000))}

\item{breaks}{integer number of histogram windows}
}
\value{
co_weight the co-inertia object
}
\description{
Perform Coinertia Analysis on the PCA
of the Weighted PCA and Deville's PCA
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
res.coinertia <- coinertia.drbats(X = res$X, t = res$t.simul, t.range = c(5, 100), breaks = 8)
res.coinertia

}
\author{
Gabrielle Weinrott
}
